
import gurobipy as gp

# Create a new model
m = gp.Model("sign_shop")

# Create variables
storefront = m.addVar(vtype=gp.GRB.CONTINUOUS, name="storefront")
street = m.addVar(vtype=gp.GRB.CONTINUOUS, name="street")

# Set objective function
m.setObjective(400 * storefront + 120 * street, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * storefront + 1 * street <= 100, "cutting")
m.addConstr(1 * storefront + 0.5 * street <= 50, "printing")
m.addConstr(2 * storefront + 0.8 * street <= 60, "assembly")
m.addConstr(storefront >= 0, "storefront_nonneg")
m.addConstr(street >= 0, "street_nonneg")


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Storefront signs: {storefront.x}")
    print(f"Street signs: {street.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

