
from gurobipy import *

# Create a model
m = Model("Sign_Shop_Optimization")

# Define variables
x1 = m.addVar(name='x1', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='x2', vtype=GRB.CONTINUOUS, lb=0)

# Set objective function
m.setObjective(400*x1 + 120*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + x2 <= 100, name='cutting_time')
m.addConstr(x1 + 0.5*x2 <= 50, name='printing_time')
m.addConstr(2*x1 + 0.8*x2 <= 60, name='assembly_time')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Number of storefront signs: {x1.x}')
    print(f'Number of street signs: {x2.x}')
    print(f'Total profit: ${400*x1.x + 120*x2.x:.2f}')
else:
    print('No optimal solution found.')
