
import gurobipy as gp

# Create a new model
model = gp.Model("Sign_Shop_Optimization")

# Define variables
x1 = model.addVar(name="storefront_signs", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="street_signs", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(400*x1 + 120*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*x1 + x2 <= 100, name="cutting_constraint")
model.addConstr(x1 + 0.5*x2 <= 50, name="printing_constraint")
model.addConstr(2*x1 + 0.8*x2 <= 60, name="assembly_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Storefront signs: {x1.varValue}, Street signs: {x2.varValue}")
    print(f"Maximum profit: ${400*x1.varValue + 120*x2.varValue:.2f}")
else:
    print("No optimal solution found.")
