
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bike_production")

# Create variables
road_bikes = m.addVar(vtype=GRB.CONTINUOUS, name="road_bikes")
mountain_bikes = m.addVar(vtype=GRB.CONTINUOUS, name="mountain_bikes")

# Set objective function
m.setObjective(70 * road_bikes + 100 * mountain_bikes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * road_bikes + 5 * mountain_bikes <= 12, "grinder_constraint")
m.addConstr(2 * road_bikes + 2.5 * mountain_bikes <= 12, "polisher_constraint")
m.addConstr(road_bikes >= 0, "road_bikes_nonnegative")
m.addConstr(mountain_bikes >= 0, "mountain_bikes_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Road bikes to produce: {road_bikes.x}")
    print(f"Mountain bikes to produce: {mountain_bikes.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

