
from gurobipy import *

# Create a new model
m = Model("Bike_Factory")

# Define variables
x1 = m.addVar(name="road_bikes", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="mountain_bikes", vtype=GRB.CONTINUOUS, lb=0)

# Set objective function
m.setObjective(70*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 12, name="grinder_time")
m.addConstr(2*x1 + 2.5*x2 <= 12, name="polisher_time")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Road bikes: {x1.x}")
    print(f"Mountain bikes: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
