
import gurobipy as gp

# Create a new model
model = gp.Model("Bike_Factory_Optimization")

# Define variables
x1 = model.addVar(name="road_bikes", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="mountain_bikes", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(70*x1 + 100*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x1 + 5*x2 <= 12, name="grinder_constraint")
model.addConstr(2*x1 + 2.5*x2 <= 12, name="polisher_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Road Bikes: {x1.varValue}")
    print(f"Mountain Bikes: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible or has no solution.")
