
import gurobipy as gp

# Create a new model
m = gp.Model("donut_optimization")

# Create variables
chocolate = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="chocolate")
maple = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="maple")


# Set objective function
m.setObjective(2 * chocolate + 3 * maple, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(chocolate >= 50, "chocolate_min")
m.addConstr(maple >= 75, "maple_min")
m.addConstr(chocolate <= 100, "chocolate_max")
m.addConstr(maple <= 150, "maple_max")
m.addConstr(chocolate + maple >= 200, "total_min")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Chocolate donuts: {chocolate.x}")
    print(f"Maple donuts: {maple.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

