
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define variables
x1 = m.addVar(lb=0, ub=100, vtype=GRB.INTEGER, name="chocolate_donuts")
x2 = m.addVar(lb=0, ub=150, vtype=GRB.INTEGER, name="maple_donuts")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 50, "min_chocolate")
m.addConstr(x2 >= 75, "min_maple")
m.addConstr(x1 <= 100, "max_chocolate")
m.addConstr(x2 <= 150, "max_maple")
m.addConstr(x1 + x2 >= 200, "total_donuts")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate Donuts: {x1.x}")
    print(f"Maple Donuts: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
