
import gurobipy as gp

# Create a new model
model = gp.Model("Donut_Optimization")

# Define the variables
x1 = model.addVar(lb=0, name="chocolate_donuts", vtype=gp.GRB.INTEGER)
x2 = model.addVar(lb=0, name="maple_donuts", vtype=gp.GRB.INTEGER)

# Objective function: Maximize 2*x1 + 3*x2
model.setObjective(2*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 >= 50, name="min_chocolate_demand")
model.addConstr(x2 >= 75, name="min_maple_demand")
model.addConstr(x1 <= 100, name="max_chocolate_production")
model.addConstr(x2 <= 150, name="max_maple_production")
model.addConstr(x1 + x2 >= 200, name="total_donuts")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Chocolate donuts = {x1.varValue}, Maple donuts = {x2.varValue}")
    print(f"Maximum profit: ${2*x1.varValue + 3*x2.varValue}")
else:
    print("No optimal solution found")
