
import gurobipy as gp

# Create a new model
model = gp.Model("RefrigeratorProduction")

# Create variables
x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="regular_refrigerators") # number of regular refrigerators
x2 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="energy_efficient_refrigerators") # number of energy-efficient refrigerators


# Set objective function
model.setObjective(50*x1 + 80*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 >= 25, "demand_regular")
model.addConstr(x2 >= 40, "demand_energy_efficient")
model.addConstr(x1 <= 100, "capacity_regular")
model.addConstr(x2 <= 70, "capacity_energy_efficient")
model.addConstr(x1 + x2 >= 90, "contract_minimum")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular refrigerators: {x1.x}")
    print(f"Number of energy-efficient refrigerators: {x2.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

