
from gurobipy import *

# Create a new model
m = Model("RefrigeratorProduction")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_refrigerators")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="energy_efficient_refrigerators")

# Set the objective function
m.setObjective(50*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 25, "regular_demand")
m.addConstr(x2 >= 40, "efficient_demand")
m.addConstr(x1 <= 100, "regular_limit")
m.addConstr(x2 <= 70, "efficient_limit")
m.addConstr(x1 + x2 >= 90, "total_contract")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Refrigerators: {x1.x}")
    print(f"Energy Efficient Refrigerators: {x2.x}")
    print(f"Total Profit: ${50*x1.x + 80*x2.x}")
else:
    print("No optimal solution found")
