
import gurobi

def solve_furniture_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=100, name="regular_refrigerators")
    x2 = model.addVar(lb=0, ub=70, name="energy_efficient_refrigerators")

    # Set the objective function
    model.setObjective(50 * x1 + 80 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 >= 25, name="demand_regular")
    model.addConstr(x2 >= 40, name="demand_energy_efficient")
    model.addConstr(x1 <= 100, name="capacity_regular")
    model.addConstr(x2 <= 70, name="capacity_energy_efficient")
    model.addConstr(x1 + x2 >= 90, name="total_demand")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${50 * x1.varValue + 80 * x2.varValue}")
    else:
        print("No optimal solution found.")

solve_furniture_company_problem()
