
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("luca_investment")

# Create variables
fishing = m.addVar(name="fishing")
education = m.addVar(name="education")

# Set objective function
m.setObjective(1.3 * fishing + 2.1 * education, GRB.MAXIMIZE)

# Add constraints
m.addConstr(fishing + education <= 20000, "total_investment")
m.addConstr(education >= 5000, "min_education")
m.addConstr(fishing >= 0.3 * (fishing + education), "min_fishing_ratio")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Invest ${fishing.x} in fishing")
    print(f"Invest ${education.x} in education")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

