
import gurobi

def luca_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="dollars_in_fishing")
    x2 = model.addVar(lb=0, name="dollars_in_education")

    # Objective function: Maximize 1.30x1 + 2.10x2
    model.setObjective(1.30 * x1 + 2.10 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 20000, name="total_investment")
    model.addConstr(x2 >= 5000, name="min_education_investment")
    model.addConstr(x1 >= (3/7) * x2, name="fishing_investment_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Invest ${x1.x:.2f} in the fishing industry.")
        print(f"Invest ${x2.x:.2f} in the education industry.")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

luca_investment_problem()
