
import gurobipy as gp

# Create a new model
m = gp.Model("sign_production")

# Create variables
led_signs = m.addVar(vtype=gp.GRB.INTEGER, name="led_signs")
neon_signs = m.addVar(vtype=gp.GRB.INTEGER, name="neon_signs")

# Set objective function
m.setObjective(1500 * led_signs + 1450 * neon_signs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(led_signs <= 3, "LED_production_limit")
m.addConstr(neon_signs <= 4, "Neon_production_limit")
m.addConstr(led_signs + neon_signs <= 7, "QC_limit")
m.addConstr(led_signs >=0)
m.addConstr(neon_signs >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of LED signs to produce: {led_signs.x}")
    print(f"Number of Neon signs to produce: {neon_signs.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

