
from gurobipy import *

# Create a new model
m = Model("Sign_Making_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="LED_Signs")
x2 = m.addVar(vtype=GRB.INTEGER, name="Neon_Signs")

# Objective function: Maximize profit
m.setObjective(1500*x1 + 1450*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 <= 3, "Max_LED_Signs")
m.addConstr(x2 <= 4, "Max_Neon_Signs")
m.addConstr(x1 + x2 <= 7, "Total_Checks")
m.addConstr(x1 >= 0, "NonNegative_LED")
m.addConstr(x2 >= 0, "NonNegative_Neon")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: ${1500*x1.x + 1450*x2.x}")
else:
    print("No optimal solution found")
