
import gurobi

def solve_sign_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='LED_signs', vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name='neon_signs', vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Maximize profit
    model.setObjective(1500 * x1 + 1450 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 <= 3, name='Team_A_capacity')
    model.addConstr(x2 <= 4, name='Team_B_capacity')
    model.addConstr(x1 + x2 <= 7, name='QC_inspector_capacity')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: LED signs = {x1.varValue}, neon signs = {x2.varValue}")
        print(f"Max Profit: ${1500*x1.varValue + 1450*x2.varValue}")
    else:
        print("The model is infeasible")

solve_sign_problem()
