
import gurobipy as gp

# Create a new model
m = gp.Model("investment_problem")

# Create variables
fishing = m.addVar(name="fishing")
transportation = m.addVar(name="transportation")

# Set objective function
m.setObjective(0.3 * fishing + 0.15 * transportation, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(fishing + transportation <= 20000, "total_investment")
m.addConstr(fishing >= 0.4 * 20000, "fishing_minimum")
m.addConstr(transportation >= 5000, "transportation_minimum")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest ${fishing.x:.2f} in fishing")
    print(f"Invest ${transportation.x:.2f} in transportation")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

