
from gurobipy import *

# Create a new model
m = Model("Marty_Investment")

# Define variables
x1 = m.addVar(name="Fishing", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Transportation", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(0.3*x1 + 0.15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 20000, name="Total_Investment")
m.addConstr(x1 >= 8000, name="Fishing_Minimum")
m.addConstr(x2 >= 5000, name="Transportation_Minimum")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
