
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="fishing_investment", lb=0)
    x2 = model.addVar(name="transportation_investment", lb=0)

    # Objective function: maximize 0.3*x1 + 0.15*x2
    model.setObjective(0.3 * x1 + 0.15 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 20000, name="total_investment")
    model.addConstr(x1 >= 8000, name="fishing_investment_min")
    model.addConstr(x2 >= 5000, name="transportation_investment_min")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in fishing industry: ", x1.varValue)
        print("Optimal investment in transportation industry: ", x2.varValue)
        print("Maximum return: ", model.objVal)
    else:
        print("The model is infeasible")

solve_investment_problem()
