
import gurobipy as gp

# Create a new model
model = gp.Model("gummy_vitamins")

# Create variables
blue_gummies = model.addVar(vtype=gp.GRB.CONTINUOUS, name="blue_gummies")
red_gummies = model.addVar(vtype=gp.GRB.CONTINUOUS, name="red_gummies")


# Set objective function
model.setObjective(2 * blue_gummies + 3 * red_gummies, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * blue_gummies + 4 * red_gummies >= 40, "calcium_req")
model.addConstr(2 * blue_gummies + 3 * red_gummies >= 45, "vitamin_a_req")
model.addConstr(5 * blue_gummies + 2 * red_gummies >= 20, "iron_req")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {model.objVal}")
    print(f"Number of blue gummies: {blue_gummies.x}")
    print(f"Number of red gummies: {red_gummies.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

