
from gurobipy import *

# Create a model
m = Model("Gummy_Vitamins")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="blue_gummies", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="red_gummies", lb=0)

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 >= 40, "calcium")
m.addConstr(2*x1 + 3*x2 >= 45, "vitamin_A")
m.addConstr(5*x1 + 2*x2 >= 20, "iron")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blue Gummies: {x1.x}")
    print(f"Red Gummies: {x2.x}")
    print(f"Total Cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
