
import gurobipy as gp

# Create a new model
m = gp.Model("Gummy_Vitamins")

# Define the variables
x1 = m.addVar(name="blue_gummies", lb=0, vtype=gp.GRB.INTEGER)  # Number of blue gummies
x2 = m.addVar(name="red_gummies", lb=0, vtype=gp.GRB.INTEGER)  # Number of red gummies

# Define the objective function
m.setObjective(2*x1 + 3*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 >= 40, name="calcium_requirement")
m.addConstr(2*x1 + 3*x2 >= 45, name="vitamin_A_requirement")
m.addConstr(5*x1 + 2*x2 >= 20, name="iron_requirement")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Optimal cost: {m.objVal}")
else:
    print("No optimal solution found")
