
from gurobipy import Model, GRB

# Create a new model
m = Model("movie_promotion")

# Create variables
social_media = m.addVar(lb=10, ub=20, vtype=GRB.INTEGER, name="social_media")
magazine_covers = m.addVar(lb=24, vtype=GRB.INTEGER, name="magazine_covers")

# Set objective function
m.setObjective(100000 * social_media + 54000 * magazine_covers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3000 * social_media + 6000 * magazine_covers <= 500000, "budget")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal exposure: {m.objVal}")
    print(f"Number of social media adverts: {social_media.x}")
    print(f"Number of magazine covers: {magazine_covers.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

