
from gurobipy import *

# Create a new model
m = Model("Movie_Exposure")

# Define variables
x1 = m.addVar(lb=10, ub=20, vtype=GRB.INTEGER, name="social_media_adverts")
x2 = m.addVar(lb=24, vtype=GRB.INTEGER, name="magazine_covers")

# Set the objective function
m.setObjective(100000*x1 + 54000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3000*x1 + 6000*x2 <= 500000, name="budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Social Media Adverts: {x1.x}")
    print(f"Magazine Covers: {x2.x}")
    print(f"Maximum Exposure: {m.objVal}")
else:
    print("No optimal solution found")
