
import gurobipy as gp

# Create a new model
model = gp.Model("Film_Agency_Optimization")

# Define variables
x1 = model.addVar(lb=10, ub=20, vtype=gp.GRB.INTEGER, name="social_media_adverts")
x2 = model.addVar(lb=24, vtype=gp.GRB.INTEGER, name="magazine_covers")

# Objective function: maximize exposure
model.setObjective(100000*x1 + 54000*x2, gp.GRB.MAXIMIZE)

# Budget constraint
model.addConstr(3000*x1 + 6000*x2 <= 500000, name="budget_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Number of social media adverts: {x1.varValue}")
    print(f"Number of magazine covers: {x2.varValue}")
    print(f"Maximum exposure: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
