
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_optimization")

# Create variables
couches = m.addVar(vtype=GRB.INTEGER, name="couches")
beds = m.addVar(vtype=GRB.INTEGER, name="beds")

# Set objective function
m.setObjective(200*couches + 400*beds, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*couches + 20*beds <= 300, "space_constraint")
m.addConstr(beds >= 0.5*(couches + beds), "bed_ratio_constraint")
m.addConstr(300*couches + 600*beds <= 8000, "budget_constraint")
m.addConstr(couches >= 0, "non_negativity_couches")
m.addConstr(beds >= 0, "non_negativity_beds")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of couches: {couches.x}")
    print(f"Number of beds: {beds.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

