
from gurobipy import *

# Create a new model
m = Model("Furniture_Store_Profit_Maximization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="number_of_couches")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="number_of_beds")

# Set the objective function
m.setObjective(200*x1 + 400*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x1 + 20*x2 <= 300, "space_constraint")
m.addConstr(x2 >= x1, "minimum_beds_constraint")
m.addConstr(300*x1 + 600*x2 <= 8000, "budget_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of couches: {x1.x}")
    print(f"Number of beds: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
