
import gurobi

def solve_furniture_store_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='couches', obj=200, lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='beds', obj=400, lb=0, vtype=gurobi.GRB.INTEGER)

    # Add constraints
    model.addConstr(15*x1 + 20*x2 <= 300, name='space_constraint')
    model.addConstr(x2 >= 0.5*(x1 + x2), name='min_beds_constraint')
    model.addConstr(300*x1 + 600*x2 <= 8000, name='capital_constraint')

    # Set the objective function
    model.setObjective(200*x1 + 400*x2, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_furniture_store_problem()
