
import gurobipy as gp

# Create a new model
m = gp.Model("stuffed_animals")

# Create variables
beavers = m.addVar(vtype=gp.GRB.INTEGER, name="beavers")
bears = m.addVar(vtype=gp.GRB.INTEGER, name="bears")

# Set objective function
m.setObjective(5 * beavers + 7 * bears, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * beavers + 15 * bears <= 2000, "time_constraint")
m.addConstr(beavers >= 3 * bears, "beaver_demand")
m.addConstr(beavers >=0, "beaver_nonneg")
m.addConstr(bears >=0, "bear_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of beavers to make: {beavers.x}")
    print(f"Number of bears to make: {bears.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

