
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="beavers", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="bears", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 15 * x2 <= 2000, name="time_constraint")
    model.addConstr(x1 >= 3 * x2, name="beaver_to_bear_ratio")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
