
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
vaccine_investment = m.addVar(name="vaccine_investment")
meat_replacement_investment = m.addVar(name="meat_replacement_investment")

# Set objective function
m.setObjective(0.05 * vaccine_investment + 0.07 * meat_replacement_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(vaccine_investment + meat_replacement_investment <= 100000, "total_investment")
m.addConstr(meat_replacement_investment >= 0.6 * (vaccine_investment + meat_replacement_investment), "meat_replacement_min")
m.addConstr(vaccine_investment <= 0.3 * (vaccine_investment + meat_replacement_investment), "vaccine_max")
m.addConstr(vaccine_investment >= 0, "vaccine_non_negative")
m.addConstr(meat_replacement_investment >= 0, "meat_replacement_non_negative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in vaccine industry: {vaccine_investment.x}")
    print(f"Optimal investment in meat-replacement industry: {meat_replacement_investment.x}")
    print(f"Optimal total return: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

