
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the variables
x1 = m.addVar(name="vaccine_investment", lb=0)
x2 = m.addVar(name="meat_replacement_investment", lb=0)

# Set the objective function
m.setObjective(0.05*x1 + 0.07*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 100000, name="total_investment")
m.addConstr(x2 >= 60000, name="meat_replacement_minimum")
m.addConstr(x1 <= 30000, name="vaccine_maximum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Amount invested in vaccine industry: {x1.x}")
    print(f"Amount invested in meat-replacement industry: {x2.x}")
else:
    print("No optimal solution found.")

