
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Optimization")

# Define the variables
x1 = model.addVar(name="vaccine_investment", lb=0)
x2 = model.addVar(name="meat_replacement_investment", lb=0)

# Objective function: Maximize 0.05*x1 + 0.07*x2
model.setObjective(0.05 * x1 + 0.07 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 100000, name="total_investment")
model.addConstr(x2 >= 0.6 * 100000, name="meat_replacement_min")
model.addConstr(x1 <= 0.3 * 100000, name="vaccine_max")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in vaccine industry: ${x1.varValue:.2f}")
    print(f"Optimal investment in meat-replacement industry: ${x2.varValue:.2f}")
    print(f"Maximal return: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
