
import gurobipy as gp

# Create a new model
m = gp.Model("dog_food")

# Create variables
x1 = m.addVar(lb=0, name="servings_dog_food_A") # Servings of dog food A
x2 = m.addVar(lb=0, name="servings_dog_food_B") # Servings of dog food B

# Set objective function
m.setObjective(3*x1 + 5*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 8*x2 >= 30, "mineral_req") # Mineral requirement
m.addConstr(5*x1 + 2*x2 >= 40, "vitamin_req") # Vitamin requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Servings of dog food A: {x1.x:.2f}")
    print(f"Servings of dog food B: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

