
from gurobipy import *

# Create a new model
m = Model("dog_food")

# Create variables
x1 = m.addVar(lb=0, name="dog_food_A")
x2 = m.addVar(lb=0, name="dog_food_B")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 8*x2 >= 30, name="minerals")
m.addConstr(5*x1 + 2*x2 >= 40, name="vitamins")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of dog food A: {x1.x}")
    print(f"Servings of dog food B: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
