
import gurobi

def solve_dog_food_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="dog_food_A", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="dog_food_B", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 8*x2 >= 30, name="minerals_constraint")
    model.addConstr(5*x1 + 2*x2 >= 40, name="vitamins_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Servings of dog food A: {x1.varValue}")
        print(f"Servings of dog food B: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_dog_food_problem()
