
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bag_production")

# Create variables
handbags = m.addVar(vtype=GRB.INTEGER, name="handbags")
backpacks = m.addVar(vtype=GRB.INTEGER, name="backpacks")

# Set objective function
m.setObjective(75 * handbags + 60 * backpacks, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * handbags + 7 * backpacks <= 400, "sewing_constraint")
m.addConstr(3 * handbags + 5 * backpacks <= 600, "painting_constraint")
m.addConstr(handbags >= 0, "handbags_nonnegative")
m.addConstr(backpacks >= 0, "backpacks_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of hand-bags: {handbags.x}")
    print(f"Number of backpacks: {backpacks.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

