
from gurobipy import *

# Create a new model
m = Model("Fashion_Company_Profit")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hand-bags")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="backpacks")

# Set the objective function
m.setObjective(75*x1 + 60*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 7*x2 <= 400, "sewing_time")
m.addConstr(3*x1 + 5*x2 <= 600, "painting_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of hand-bags: {x1.x}")
    print(f"Number of backpacks: {x2.x}")
    print(f"Maximum profit: ${75*x1.x + 60*x2.x:.2f}")
else:
    print("No optimal solution found")
