
import gurobi

def solve_bag_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hand-bags", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="backpacks", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 75*x1 + 60*x2
    model.setObjective(75*x1 + 60*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6*x1 + 7*x2 <= 400, name="sewing_time")
    model.addConstr(3*x1 + 5*x2 <= 600, name="painting_time")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: hand-bags = {x1.varValue}, backpacks = {x2.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_bag_production()
