
import gurobipy as gp

# Create a new model
model = gp.Model("BurritoOptimization")

# Create variables
beef = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="beef")
pork = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="pork")


# Set objective function
model.setObjective(3.5 * beef + 2.1 * pork, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(beef + pork <= 100, "Total burritos")
model.addConstr(beef >= 20, "Minimum beef burritos")
model.addConstr(pork >= 30, "Minimum pork burritos")
model.addConstr(beef <= 70, "Maximum beef burritos")
model.addConstr(pork <= 80, "Maximum pork burritos")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of beef burritos: {beef.x}")
    print(f"Number of pork burritos: {pork.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

