
from gurobipy import *

# Create a new model
model = Model("Burrito_Optimization")

# Create variables
x1 = model.addVar(lb=20, ub=70, vtype=GRB.INTEGER, name="beef_burritos")
x2 = model.addVar(lb=30, ub=80, vtype=GRB.INTEGER, name="pork_burritos")

# Set the objective function
model.setObjective(3.5*x1 + 2.1*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 100, "total_burritos")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Beef burritos: {x1.x}")
    print(f"Pork burritos: {x2.x}")
    print(f"Total profit: {3.5*x1.x + 2.1*x2.x}")
else:
    print("No optimal solution found")
