
import gurobipy as gp

def solve_burrito_problem():
    # Create a new model
    model = gp.Model("Burrito_Problem")

    # Define variables
    x1 = model.addVar(name="beef_burritos", lb=0, ub=100, vtype=gp.GRB.INTEGER)
    x2 = model.addVar(name="pork_burritos", lb=0, ub=100, vtype=gp.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(3.5 * x1 + 2.1 * x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_burritos")
    model.addConstr(x1 >= 20, name="min_beef_burritos")
    model.addConstr(x2 >= 30, name="min_pork_burritos")
    model.addConstr(x1 <= 70, name="max_beef_burritos")
    model.addConstr(x2 <= 80, name="max_pork_burritos")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal Solution: Beef Burritos = {x1.varValue}, Pork Burritos = {x2.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_burrito_problem()
