
import gurobipy as gp

# Create a new model
m = gp.Model("Andy's Drink Optimization")

# Create variables
chocolate_milk = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chocolate_milk")
vegetable_juice = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vegetable_juice")


# Set objective function
m.setObjective(3.5 * chocolate_milk + 6 * vegetable_juice, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * chocolate_milk + 9 * vegetable_juice >= 20, "potassium")
m.addConstr(4 * chocolate_milk + 5 * vegetable_juice >= 8, "magnesium")
m.addConstr(5 * chocolate_milk + 7 * vegetable_juice >= 12, "calcium")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Optimal Chocolate Milk Bottles: {chocolate_milk.x}")
    print(f"Optimal Vegetable Juice Bottles: {vegetable_juice.x}")
    print(f"Minimum Cost: ${m.objVal}")

