
from gurobipy import *

# Create a new model
m = Model("Andy_Drinks")

# Define the variables
x1 = m.addVar(lb=0, name="chocolate_milk")
x2 = m.addVar(lb=0, name="vegetable_juice")

# Set the objective function
m.setObjective(3.5*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 9*x2 >= 20, "potassium")
m.addConstr(4*x1 + 5*x2 >= 8, "magnesium")
m.addConstr(5*x1 + 7*x2 >= 12, "calcium")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bottles of chocolate milk: {x1.x}")
    print(f"Number of bottles of vegetable juice: {x2.x}")
    print(f"Minimum cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
