
import gurobi as gp

# Create a new model
m = gp.Model("Drink_Mix")

# Define the variables
x1 = m.addVar(name="chocolate_milk", lb=0)  # Number of bottles of chocolate milk
x2 = m.addVar(name="vegetable_juice", lb=0)  # Number of bottles of vegetable juice

# Define the objective function
m.setObjective(3.5 * x1 + 6 * x2, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(6 * x1 + 9 * x2 >= 20, name="potassium_constraint")
m.addConstr(4 * x1 + 5 * x2 >= 8, name="magnesium_constraint")
m.addConstr(5 * x1 + 7 * x2 >= 12, name="calcium_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Bottles of chocolate milk: {x1.x:.2f}")
    print(f"Bottles of vegetable juice: {x2.x:.2f}")
else:
    print("The model is infeasible.")
