
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Restaurant Staffing")

# Create variables
new_cooks = m.addVar(lb=0, vtype=GRB.INTEGER, name="new_cooks")
senior_cooks = m.addVar(lb=0, vtype=GRB.INTEGER, name="senior_cooks")

# Set objective function
m.setObjective(500 * new_cooks + 1000 * senior_cooks, GRB.MINIMIZE)

# Add constraints
m.addConstr(500 * new_cooks + 1000 * senior_cooks <= 50000, "Wage Bill")
m.addConstr(new_cooks + senior_cooks >= 30, "Total Cooks")
m.addConstr(senior_cooks >= 5, "Minimum Senior Cooks")
m.addConstr(senior_cooks >= (1/3) * new_cooks, "Senior to New Cook Ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of new cooks: {new_cooks.x}")
    print(f"Number of senior cooks: {senior_cooks.x}")
    print(f"Total weekly wage: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

