
from gurobipy import *

# Create a new model
m = Model("Restaurant_Cooks")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="new_cooks")
x2 = m.addVar(vtype=GRB.INTEGER, name="senior_cooks")

# Set the objective function
m.setObjective(500*x1 + 1000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(500*x1 + 1000*x2 <= 50000, "total_wage_bill")
m.addConstr(x1 + x2 >= 30, "total_cooks")
m.addConstr(x2 >= 5, "senior_cooks_minimum")
m.addConstr(x2 >= (1/3)*x1, "senior_to_new_ratio")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of new cooks: {x1.x}")
    print(f"Number of senior cooks: {x2.x}")
    print(f"Total wage bill: ${500*x1.x + 1000*x2.x}")
else:
    print("No optimal solution found")
