
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="new_cooks")
x2 = model.addVar(lb=0, name="senior_cooks")

# Objective function: minimize the wage bill
model.setObjective(500*x1 + 1000*x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(500*x1 + 1000*x2 <= 50000, name="wage_bill")
model.addConstr(x1 + x2 >= 30, name="total_cooks")
model.addConstr(x2 >= 5, name="senior_cooks_min")
model.addConstr(x2 >= (1/3)*x1, name="senior_to_new_ratio")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of new cooks: {x1.varValue}")
    print(f"Number of senior cooks: {x2.varValue}")
    print(f"Minimum wage bill: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
