
import gurobipy as gp

# Create a new model
m = gp.Model("workout_drinks")

# Create variables
sports_drink = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sports_drink")
coconut_water = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="coconut_water")


# Set objective function
m.setObjective(5 * sports_drink + 3 * coconut_water, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * sports_drink + 4 * coconut_water >= 10, "calcium")
m.addConstr(2 * sports_drink + 1 * coconut_water >= 15, "potassium")
m.addConstr(3 * sports_drink + 2 * coconut_water >= 13, "magnesium")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: {m.objVal}")
    print(f"Sports drinks: {sports_drink.x}")
    print(f"Coconut water: {coconut_water.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

